import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.movementTypeId) {
    newObjValue = {...newObjValue, 
      MovementType: {
        id: body.movementTypeId
      }
    }
  }
  if(body.locatorId) {
    newObjValue = {...newObjValue, 
      M_Locator_ID: {
        id: body.locatorId,
        tableName: 'M_Locator'
      }
    }
  }
  if(body.movementLineId) {
    newObjValue = {...newObjValue, 
      M_MovementLine_ID: {
        id: body.movementLineId,
        tableName: 'M_MovementLine'
      }
    }
  }
  if(body.attributeSetInstanceId) {
    newObjValue = {...newObjValue, 
      M_AttributeSetInstance_ID: {
        id: body.attributeSetInstanceId,
        tableName: 'M_AttributeSetInstance'
      }
    }
  }
  if(body.inOutLineId) {
    newObjValue = {...newObjValue, 
      M_InOutLine_ID: {
        id: body.inOutLineId,
        tableName: 'M_InOutLine'
      }
    }
  }
  if(body.inventoryLineId) {
    newObjValue = {...newObjValue, 
      M_InventoryLine_ID: {
        id: body.inventoryLineId,
        tableName: 'M_InventoryLine'
      }
    }
  }
  if(body.movementLineId) {
    newObjValue = {...newObjValue, 
      M_MovementLine_ID: {
        id: body.movementLineId,
        tableName: 'M_MovementLine'
      }
    }
  }
  if(body.productionLineId) {
    newObjValue = {...newObjValue, 
      M_ProductionLine_ID: {
        id: body.productionLineId,
        tableName: 'M_ProductionLine'
      }
    }
  }
  if(body.projectIssueId) {
    newObjValue = {...newObjValue, 
      C_ProjectIssue_ID: {
        id: body.projectIssueId,
        tableName: 'C_ProjectIssue'
      }
    }
  }
  if(body.costCollectorId) {
    newObjValue = {...newObjValue, 
      PP_Cost_Collector_ID: {
        id: body.costCollectorId,
        tableName: 'PP_Cost_Collector'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/m_transaction/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      movementDate: body.movementDate,
      movementQty: body.movementQty,
      ...newObjValue,
      tableName: 'm_transaction'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    if(err.status >= 500 || err.statusCode >= 500) {
      data = {
        status: err.status || err.statusCode,
        message: err.detail || err.details || err.message || err.statusMessage
      }
    } else {
    try {
        let authToken: any = await refreshTokenHelper(event)
        data = await handleFunc(event, authToken)
      } catch(error: any) {
        data = {
          status: error.status || error.statusCode || 500,
          message: error.detail || error.details || error.message || error.statusMessage
        }
      }
    }
  }

  return data
})